#!/bin/bash
# File: config_scanner_sdk.sh
#
# Description: DERMALOG software configuration script
#
# Author: DERMALOG
#
# Target: linux (RH,SuSE, Debian)
#
###########################################################################################

##### Read config.dat #####
 . `dirname $0`/sdk.config

DERMALOG_CACHE_DIR="/var/cache/dermalog-fingerprint-scanner-sdk-${VERSIONINFO}-x${SDK_ARCHITECTURE}"
CONFIG_NAME="config.scannersdk.dat"
CONFIG_DAT="${DERMALOG_CACHE_DIR}/${CONFIG_NAME}"

 . ${CONFIG_DAT}
###########################

###########################################################################################
#
# Print created Group
#
###########################################################################################
printGroup(){
	if ! [ -z "$SCANNER_GROUP" ]; then
		echo  "Created group: $SCANNER_GROUP" 
	fi
}

###########################################################################################
#
# Print created links
#
###########################################################################################
printLinks(){
	if ! [ -z  "$SCANNER_LINKS" ]; then
		echo "Created links:"
		for link in $SCANNER_LINKS
		do
			echo -e "\t`ls -l $link |awk '{print $8,$9,$10}'`"
		done
	fi
}

###########################################################################################
#
# Print distributed files
#
###########################################################################################
printFiles(){
	if ! [ -z "$SCANNER_FILES" ]; then
		echo "Created files:"
		for fl in $SCANNER_FILES
		do
			echo -e "\t$fl"
		done
	fi
}
###########################################################################################
#
# Print distributed libs
#
###########################################################################################
printLibs(){
	if ! [ -z "$SCANNER_LIBS" ]; then
		echo "Libs availible:"
		for lib in $SCANNER_LIBS
		do
			echo -e "\t`basename $lib` -> `dirname $lib`" 
		done
	fi
}

###########################################################################################
#
# Print created directorys
#
###########################################################################################
printDirectories(){
	if ! [ -z "$SCANNER_DIRS" ]; then
		echo "Created direcories:"
		for dir in $SCANNER_DIRS
		do
			echo -e "\t$dir"
		done
	fi
}

##########################################################################################
#
# Print usage.
#
##########################################################################################
usage(){
	echo "${SDK_NAME} ${VERSIONINFO} ${SDK_ARCHITECTURE}bit"
	echo "Usage: `basename $0`"
    echo -e "\t--libs  to print installedlibs."
	echo -e "\t--files to print installed files."
	echo -e "\t--group to print DermalogZf1 group."
	echo -e "\t--links to print created Links."
	echo -e "\t--dirs to print created directories."
	echo -e "\t--version to print package version."
	echo -e "\t--all to print everything."
	echo ""
}

if [ $# -eq 0 ]
then
	usage;
	exit 0;
fi

while [ $# -ne 0 ]; do
 case "$1" in
	--libs)
		printLibs;
		shift;;
	--files)
		printFiles;
		shift;;
	--links)
		printLinks;
		shift;;
	--dirs)
		printDirectories;
		shift;;
	--group)
		printGroup;
		shift;;
	--version) 
		echo "DERMALOG Fingerprint Scanner SDK $VERSIONINFO" 
		shift;;
	--all) 
		echo "DERMALOG Fingerprint Scanner SDK $VERSIONINFO" 
		printLibs;
		printFiles;
		printLinks;
		printDirectories;
		printGroup;
		exit 0;;
	*)
		usage;
		break;;
	
 esac	 
done
