#!/bin/bash
# File: uninstall_scanner_sdk.sh
#
# Description: DERMALOG software uninstallation script
#
# Author: DERMALOG
#
# Target: linux (RH,SuSE, Debian)
# 
###########################################################################################

##### Read config.dat #####

. `dirname $0`/sdk.config

DERMALOG_CACHE_DIR="/var/cache/dermalog-fingerprint-scanner-sdk-${VERSIONINFO}-x${SDK_ARCHITECTURE}"
CONFIG_NAME="config.scannersdk.dat"
CONFIG_DAT="${DERMALOG_CACHE_DIR}/${CONFIG_NAME}"

 . ${CONFIG_DAT}
###########################

###########################################################################################
#
# Delete created Group
#
###########################################################################################
deleteGroup(){
	if ! [ -z "$SCANNER_GROUP" ]; then
		echo -e "Delete group $SCANNER_GROUP ..." 
		groupdel $SCANNER_GROUP
	fi
}

###########################################################################################
#
# Delete Created Links
#
###########################################################################################
deleteLinks(){
	if ! [ -z  "$SCANNER_LINKS" ]; then
		echo -e "Remove created links..."
		for link in $SCANNER_LINKS
		do
			rm -f $link
		done
	fi
}

###########################################################################################
#
# Delete Distribution Files
#
###########################################################################################
deleteFiles(){
	if ! [ -z "$SCANNER_FILES" ]; then
		echo -e "Remove created files..."
		for fl in $SCANNER_FILES
		do
			rm -f $fl
		done
	fi
}

###########################################################################################
#
# Delete Directories
#
###########################################################################################
deleteDirectories(){
	if ! [ -z "$SCANNER_DIRS" ]; then
		echo -e "Remove created direcories..."
		for dir in $SCANNER_DIRS
		do
			rm -rf $dir
		done
	fi
}
deleteLinks
deleteFiles
deleteDirectories
deleteGroup
rm -rf $CONFIG_PATH
rm -rf $DERMALOG_INSTALL

